#!/usr/bin/env ruby
# -*- encoding: UTF-8 -*-
if RUBY_VERSION >= '1.9.0'
  Encoding.default_external = 'UTF-8'
end

require 'gtk2'
require 'date'
include Math

# 表示方法：画面を回転させるか、させないか
$flgRotate = true  # 回転する。
# $flgRotate = false # 回転させない。

# 表示方法：文字列を表示させるか、させないか
$flgText = true  # 表示する。
# $flgText = false # 表示させない。

# 数値積分の計算ステップ
StepTime = 5.0 # day
#アニメーション表示のフレームあたりのステップ数
StepPerFrame = 5
#アニメーション表示を1秒間に何フレーム表示するか
FPS = 10 # fps

# 重力定数と太陽質量の積
GMs = 1.32712438e20
# 重力定数と木星質量の積
GMj = 1.26687197e17
# 天文単位（太陽から地球までの距離 単位メートル）
AU  = 1.4959787e11

$asteroidElements = [
  [5.1965989,0.14824319,10.31961,316.59641,
   132.84075,22.8285485,56000.0,"アキレス"],
  [5.2170339,0.13985452,22.05278,44.36645,
   308.01876,348.2219031,56000.0,"パトロクロス"],
  [5.2432861,0.02330271,18.17911,342.80946,
   179.82385,321.0404487,56000.0,"ヘクトル"],
  [5.1305317,0.04441033,26.90978,283.70329,
   1.21065,57.9530534,56000.0,"デイフォブス"],
  [1.3240387,0.28030108,1.62189,69.08346,
   162.77503,47.1293455,56000.0,"イトカワ"]]

$planet = {
  "木星" =>[5.202887,0.04838624,1.30439695,
            100.47390909,14.72847983,-80.80594841],
  "地球" => [1.00000261,0.01671123,-1.531e-05,
             0.0,102.93768193,-2.47311026999999],
  "火星" => [1.52371034,0.0933941,1.84969142,
             49.55953891,-23.94362959,-30.16934137]}

def getX(a,e,incl,node,peri,mm,d)
  n = sqrt(GMs / (a * AU * a * AU * a * AU)) * 24.0 * 3600.0
  mm *= (PI / 180.0)
  mm += n * d
  incl *= (PI / 180.0)
  node *= (PI / 180.0)
  peri *= (PI / 180.0)
  ee = mm - e * sin(mm)
  for i in 1..6 do
    ee = ee - (ee - e * sin(ee) - mm) / (1.0 - e * cos(ee))
  end
  r = a * (1.0 - e * cos(ee))
  x = a * ((cos(node) * cos(peri) - sin(node) * cos(incl) * sin(peri)) * (cos(ee) - e) - (cos(node) * sin(peri) + sin(node) * cos(incl) * cos(peri)) * (sqrt(1.0 - e * e) * sin(ee)))
  y = a * ((sin(node) * cos(peri) + cos(node) * cos(incl) * sin(peri)) * (cos(ee) - e) - (sin(node) * sin(peri) - cos(node) * cos(incl) * cos(peri)) * (sqrt(1.0 - e * e) * sin(ee)))
  z = a * (sin(incl) * sin(peri) * (cos(ee) - e) + sin(incl) * cos(peri) * (sqrt(1.0 - e * e) * sin(ee)))
#  vx = sqrt($gs * a * $au) / (r * $au) * ((cos(node) * cos(peri) - sin(node) * cos(incl) * sin(peri)) * (- sin(ee)) - (cos(node) * sin(peri) + sin(node) * cos(incl) * cos(peri)) * (sqrt(1.0 - e * e) * cos(ee)))
#  vy = sqrt($gs * a * $au) / (r * $au) * ((sin(node) * cos(peri) + cos(node) * cos(incl) * sin(peri)) * (- sin(ee)) - (sin(node) * sin(peri) - cos(node) * cos(incl) * cos(peri)) * (sqrt(1.0 - e * e) * cos(ee)))
#  vz = sqrt($gs * a * $au) / (r * $au) * (sin(incl) * sin(peri) * ( - sin(ee)) + sin(incl) * cos(peri) * (sqrt(1.0 - e * e) * cos(ee)))
  return x,y,z
end

def getXV(a,e,incl,node,peri,mm,d)
  a *= AU
  n = sqrt(GMs / (a * a * a)) * 24.0 * 3600.0
#  n = sqrt(GMs / (a * AU * a * AU * a * AU)) * 24.0 * 3600.0
  mm *= (PI / 180.0)
  mm += n * d
  incl *= (PI / 180.0)
  node *= (PI / 180.0)
  peri *= (PI / 180.0)
  ee = mm - e * sin(mm)
  for i in 1..6 do
    ee = ee - (ee - e * sin(ee) - mm) / (1.0 - e * cos(ee))
  end
  r = a * (1.0 - e * cos(ee))
  x = a * ((cos(node) * cos(peri) - sin(node) * cos(incl) * sin(peri)) * (cos(ee) - e) - (cos(node) * sin(peri) + sin(node) * cos(incl) * cos(peri)) * (sqrt(1.0 - e * e) * sin(ee)))
  y = a * ((sin(node) * cos(peri) + cos(node) * cos(incl) * sin(peri)) * (cos(ee) - e) - (sin(node) * sin(peri) - cos(node) * cos(incl) * cos(peri)) * (sqrt(1.0 - e * e) * sin(ee)))
  z = a * (sin(incl) * sin(peri) * (cos(ee) - e) + sin(incl) * cos(peri) * (sqrt(1.0 - e * e) * sin(ee)))
  vx = sqrt(GMs * a) / (r) * ((cos(node) * cos(peri) - sin(node) * cos(incl) * sin(peri)) * (- sin(ee)) - (cos(node) * sin(peri) + sin(node) * cos(incl) * cos(peri)) * (sqrt(1.0 - e * e) * cos(ee)))
  vy = sqrt(GMs * a) / (r) * ((sin(node) * cos(peri) + cos(node) * cos(incl) * sin(peri)) * (- sin(ee)) - (sin(node) * sin(peri) - cos(node) * cos(incl) * cos(peri)) * (sqrt(1.0 - e * e) * cos(ee)))
  vz = sqrt(GMs * a) / (r) * (sin(incl) * sin(peri) * ( - sin(ee)) + sin(incl) * cos(peri) * (sqrt(1.0 - e * e) * cos(ee)))
  return x,y,z,vx,vy,vz
end

class DXV
  attr_reader :x,:y,:z,:vx,:vy,:vz
  def initialize(x,y,z,vx,vy,vz)
    @x = x
    @y = y
    @z = z
    @vx = vx
    @vy = vy
    @vz = vz
  end
  def *(other)
    DXV.new(@x * other,@y * other,@z * other,@vx * other,@vy * other,@vz * other)
  end
  def /(other)
    DXV.new(@x / other,@y / other,@z / other,@vx / other,@vy / other,@vz / other)
  end
end

class XV
  attr_reader :x,:y,:z,:vx,:vy,:vz
  def initialize(x,y,z,vx,vy,vz)
    @x = x
    @y = y
    @z = z
    @vx = vx
    @vy = vy
    @vz = vz
  end
  def f(t)
    e = $planet["木星"]
    xj,yj,zj,vx,vy,vz = getXV(e[0],e[1],e[2],e[3],e[4],e[5],t.ajd().to_f()-2451545.0)
    xs = - xj * GMj / GMs
    ys = - yj * GMj / GMs
    zs = - zj * GMj / GMs
    r3 = ((@x - xs) * (@x - xs) + (@y - ys) * (@y - ys) + (@z - zs) * (@z - zs)) ** (1.5)
    ax = - GMs / r3 * (@x - xs)
    ay = - GMs / r3 * (@y - ys)
    az = - GMs / r3 * (@z - zs)
    r3 = ((@x - xj) * (@x - xj) + (@y - yj) * (@y - yj) + (@z - zj) * (@z - zj)) ** (1.5)
    ax -= GMj / r3 * (@x - xj)
    ay -= GMj / r3 * (@y - yj)
    az -= GMj / r3 * (@z - zj)
    DXV.new(@vx,@vy,@vz,ax,ay,az)
  end
  def +(other)
    XV.new(@x + other.x,@y + other.y,@z + other.z,@vx + other.vx,@vy + other.vy,@vz + other.vz)
  end
end

class NXV
  attr_reader :x,:y,:z,:vx,:vy,:vz
  def initialize(x,y,z,vx,vy,vz)
    @x = x
    @y = y
    @z = z
    @vx = vx
    @vy = vy
    @vz = vz
  end
  def f(t)
    e = $planet["木星"]
    xj,yj,zj,vx,vy,vz = getXV(e[0],e[1],e[2],e[3],e[4],e[5],t.ajd().to_f()-2451545.0)
    xs = 0.0
    ys = 0.0
    zs = 0.0
    r3 = ((@x - xs) * (@x - xs) + (@y - ys) * (@y - ys) + (@z - zs) * (@z - zs)) ** (1.5)
    ax = - GMs / r3 * (@x - xs)
    ay = - GMs / r3 * (@y - ys)
    az = - GMs / r3 * (@z - zs)
    r3 = ((@x - xj) * (@x - xj) + (@y - yj) * (@y - yj) + (@z - zj) * (@z - zj)) ** (1.5)
    ax -= GMj / r3 * (@x - xj)
    ay -= GMj / r3 * (@y - yj)
    az -= GMj / r3 * (@z - zj)
    DXV.new(@vx,@vy,@vz,ax,ay,az)
  end
  def +(other)
    NXV.new(@x + other.x,@y + other.y,@z + other.z,@vx + other.vx,@vy + other.vy,@vz + other.vz)
  end
end

class Asteroid < Gtk::VBox
  def initialize(parent)
    @parent = parent
    super()
    @t = 0.0
    @t = Date.today
    @tEnd = @t + 365.25 * 30.0
    @oldSelect = 0
    @step = StepTime

    e = $planet["木星"]
    xj,yj,zj,vxj,vyj,vzj = getXV(e[0],e[1],e[2],e[3],e[4],e[5],@t.ajd().to_f()-2451545.0)
    xs = - xj * GMj / GMs
    ys = - yj * GMj / GMs
    zs = - zj * GMj / GMs
    vxs = - vxj * GMj / GMs
    vys = - vyj * GMj / GMs
    vzs = - vzj * GMj / GMs
    @asteroidElements = []
    @asteroidElementsN = []
    $asteroidElements.each do |e|
      x,y,z,vx,vy,vz = getXV(e[0],e[1],e[2],e[3],e[4],e[5],@t.amjd().to_f() - e[6])
      @asteroidElements.push XV.new(x + xs,y + ys,z + zs,vx + vxs,vy + vys,vz + vzs)
      @asteroidElementsN.push NXV.new(x,y,z,vx,vy,vz)
    end
    @red = Gdk::Color.parse("#FF0000")
    @green = Gdk::Color.parse("#00FF00")
    @blue = Gdk::Color.parse("#0000FF")
    @black = Gdk::Color.parse("#000000")
    @colormap = Gdk::Colormap.system
    @colormap.alloc_color(@red, false, true)
    @colormap.alloc_color(@green, false, true)
    @colormap.alloc_color(@blue, false, true)
    @colormap.alloc_color(@black, false, true)
    @box = Gtk::EventBox.new
    pack_start(@box)
    set_border_width(@pad = 2)
    set_size_request((@width = 48)+(@pad*2), (@height = 48)+(@pad*2))
    signal_connect_after('show') {|w,e| start() }
    signal_connect_after('hide') {|w,e| stop() }
    signal_connect("expose_event") {|w, e| draw()}
    @box.show()
    show()
  end
  def draw()
    draw = @box.window
    x, y, width, height, depth = draw.geometry
    x0 = width / 2.0
    y0 = height / 2.0
    k = x0
    if y0 < k
      k = y0
    end
    k /= 6.0
    draw.clear
    gc = Gdk::GC.new(draw)
    l = create_pango_layout
    l.font_description=Pango::FontDescription.new("Sans 12")
    l.set_text("#{@t.year}/#{format("%02d",@t.mon)}/#{format("%02d",@t.day)}")
    draw.draw_layout(gc, 0, 0, l)
    gc.set_foreground(@red)
    draw.draw_arc(gc, true, x0 - 4, y0 - 4, 8, 8,0,64*360)
    if $flgText
      l.set_text("太陽")
      draw.draw_layout(gc, x0, y0, l)
    end
    gc.set_foreground(@blue)
    e = $planet["木星"]
    x1,y1,z = getX(e[0],e[1],e[2],e[3],e[4],e[5],@t.ajd().to_f()-2451545.0)
    theta = atan2(y1,x1) - PI / 2.0
    if $flgRotate
      theta = 0.0
    end
    x =  x1 * cos(theta) + y1 * sin(theta)
    y = -x1 * sin(theta) + y1 * cos(theta)
    draw.draw_line(gc,x0,y0,k * x + x0, - y * k + y0)
    xg =  x1 * cos(theta - PI / 3.0) + y1 * sin(theta - PI / 3.0)
    yg = -x1 * sin(theta - PI / 3.0) + y1 * cos(theta - PI / 3.0)
    draw.draw_line(gc,x0,y0,k * x + x0, - y * k + y0)
    xt =  x1 * cos(theta + PI / 3.0) + y1 * sin(theta + PI / 3.0)
    yt = -x1 * sin(theta + PI / 3.0) + y1 * cos(theta + PI / 3.0)
    draw.draw_line(gc,x0,y0,k * x + x0, - y * k + y0)
    draw.draw_line(gc,x0,y0,k * xg + x0, - yg * k + y0)
    draw.draw_line(gc,k * xg + x0, - yg * k + y0,k * x + x0, - y * k + y0)
    draw.draw_line(gc,x0,y0,k * xt + x0, - yt * k + y0)
    draw.draw_line(gc,k * xt + x0, - yt * k + y0,k * x + x0, - y * k + y0)
    if $flgText
      l.set_text("L4")
      draw.draw_layout(gc,k * xg + x0, - yg * k + y0, l)
      l.set_text("L5")
      draw.draw_layout(gc,k * xt + x0, - yt * k + y0, l)
    end

    $planet.each do |p,e|
      x1,y1,z = getX(e[0],e[1],e[2],e[3],e[4],e[5],@t.ajd().to_f()-2451545.0)
      x =  x1 * cos(theta) + y1 * sin(theta)
      y = -x1 * sin(theta) + y1 * cos(theta)
      draw.draw_arc(gc, true, k * x + x0 - 4, - y * k + y0 - 4, 8, 8,0,64*360)
      if $flgText
        l.set_text(p)
        draw.draw_layout(gc,  k * x + x0, - y * k + y0, l)
      end
    end
    gc.set_foreground(@black)
    $asteroidElements.each do |e|
      x1,y1,z = getX(e[0],e[1],e[2],e[3],e[4],e[5],@t.amjd().to_f() - e[6])
      x =  x1 * cos(theta) + y1 * sin(theta)
      y = -x1 * sin(theta) + y1 * cos(theta)
      draw.draw_arc(gc, true, k * x + x0 - 4, - y * k + y0 - 4, 8, 8,0,64*360)
      if $flgText
        l.set_text("#{e[7]} 木星太陽共に未考慮")
        draw.draw_layout(gc,  k * x + x0, - y * k + y0, l)
      end
    end
    gc.set_foreground(@red)
    i = 0
    @asteroidElementsN.each do |e|
      x =  e.x * cos(theta) + e.y * sin(theta)
      y = -e.x * sin(theta) + e.y * cos(theta)
      draw.draw_arc(gc, true, k * x / AU + x0 - 4, - y / AU * k + y0 - 4, 8, 8,0,64*360)
      if $flgText
        l.set_text("#{$asteroidElements[i][7]} 木星考慮 太陽移動未考慮")
        draw.draw_layout(gc, k * x / AU + x0, - y / AU * k + y0, l)
      end
      i += 1
    end
    gc.set_foreground(@green)
    i = 0
    @asteroidElements.each do |e|
      x =  e.x * cos(theta) + e.y * sin(theta)
      y = -e.x * sin(theta) + e.y * cos(theta)
      draw.draw_arc(gc, true, k * x / AU + x0 - 4, - y / AU * k + y0 - 4, 8, 8,0,64*360)
      if $flgText
        l.set_text("#{$asteroidElements[i][7]} 木星引力太陽移動とも考慮")
        draw.draw_layout(gc, k * x / AU + x0, - y / AU * k + y0, l)
      end
      i += 1
    end
    if @t < @tEnd
      for i in 1..FPS
        if (@t + @step) < @tEnd
          runge(@t,@step * 24.0 * 3600.0)
          @t += @step
        else
          step = @tEnd - @t
          if step > 0.0
            runge(@t,step * 24.0 * 3600.0)
            @t += step
          end
        end
      end
    else
      stop()
    end
  end
  def start
	@tid= Gtk::timeout_add(1000 / FPS) { draw(); true }
  end
  def stop
	Gtk::timeout_remove(@tid) if @tid
	@tid = nil
  end
  def runge(t,h)
    for i in 0..(@asteroidElements.size - 1) do
      k1 = @asteroidElements[i].f(t) * h
      k2 = (@asteroidElements[i] + k1 / 2.0).f(t + h / 2.0 / (24.0 * 3600.0)) * h
      k3 = (@asteroidElements[i] + k2 / 2.0).f(t + h / 2.0 / (24.0 * 3600.0)) * h
      k4 = (@asteroidElements[i] + k3).f(t + h / (24.0 * 3600.0)) * h
      @asteroidElements[i] = @asteroidElements[i] + k1 / 6.0 + k2 / 3.0 + k3 / 3.0 + k4 / 6.0
    end
    for i in 0..(@asteroidElementsN.size - 1) do
      k1 = @asteroidElementsN[i].f(t) * h
      k2 = (@asteroidElementsN[i] + k1 / 2.0).f(t + h / 2.0 / (24.0 * 3600.0)) * h
      k3 = (@asteroidElementsN[i] + k2 / 2.0).f(t + h / 2.0 / (24.0 * 3600.0)) * h
      k4 = (@asteroidElementsN[i] + k3).f(t + h / (24.0 * 3600.0)) * h
      @asteroidElementsN[i] = @asteroidElementsN[i] + k1 / 6.0 + k2 / 3.0 + k3 / 3.0 + k4 / 6.0
    end
  end
end

if $0 == __FILE__

WINDOW_SIZE = [640, 480]

class Viewer < Gtk::Window
  def initialize()
    super()
    set_title("LagrangianPoint")
    signal_connect("delete_event") { |i,a| Gtk::main_quit }
    set_default_size(*WINDOW_SIZE)
    add(Asteroid.new(self))
    show()
  end
end

Gtk.init()
$view = Viewer.new
$view.show
Gtk.main()
  
end


